{*******************************************************}
{                                                       }
{         Delphi VCL Extensions (RX)                    }
{                                                       }
{         Copyright (c) 1995, 1996 AO ROSNO             }
{         Copyright (c) 1997, 1998 Master-Bank          }
{                                                       }
{*******************************************************}

{ Note:
  - in Delphi 4.0 you must add DCLRX4 to the requires page of the
    package you install this components into.
  - in Delphi 3.0 you must add DCLRXCTL to the requires page of the
    package you install this components into.
  - in C++Builder 3.0 you must add DCLRXCTL to the requires page of the
    package you install this components into. }

unit RxDBReg;

{$I RX.INC}
{$D-,L-,S-}

interface

uses Classes, DsgnIntf, SysUtils, DB, DBTables;

{ Register data aware custom controls }

procedure Register;

implementation

{$IFDEF WIN32}
 {$R *.D32}
{$ELSE}
 {$R *.D16}
{$ENDIF}

uses TypInfo, DBLists, RXLConst, RXDBCtrl, RXLookup, DBQBE, DBFilter,
  DBIndex, DBPrgrss, DBSecur, RXQuery, RXDBComb, VCLUtils, DbExcpt,
  {$IFDEF RX_D3} QBndDlg, {$ELSE} {$IFNDEF WIN32} QBndDlg, {$ELSE}
  QBindDlg, {$ENDIF} {$ENDIF} LibHelp,
  {$IFDEF WIN32} DBRichEd, {$ENDIF} MemTable;

{ TDBStringProperty }

type
  TDBStringProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

procedure TDBStringProperty.GetValueList(List: TStrings);
begin
end;

{$IFDEF WIN32}

{ TSessionNameProperty }

type
  TSessionNameProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

procedure TSessionNameProperty.GetValueList(List: TStrings);
begin
  Sessions.GetSessionNames(List);
end;

{$ENDIF WIN32}

{ TDatabaseNameProperty }

type
  TDatabaseNameProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

procedure TDatabaseNameProperty.GetValueList(List: TStrings);
{$IFDEF WIN32}
var
  S: TSession;
{$ENDIF}
begin
{$IFDEF WIN32}
  if (GetComponent(0) is TDBDataSet) then
    (GetComponent(0) as TDBDataSet).DBSession.GetDatabaseNames(List)
  else if (GetComponent(0) is TSQLScript) then begin
    S := Sessions.FindSession((GetComponent(0) as TSQLScript).SessionName);
    if S = nil then S := Session;
    S.GetDatabaseNames(List);
  end;
{$ELSE}
  Session.GetDatabaseNames(List);
{$ENDIF}
end;

{ TRxFieldProperty }
{ For TRxDBLookupList, TRxDBLookupCombo components }

type
  TRxFieldProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
    function GetDataSourcePropName: string; virtual;
  end;

function TRxFieldProperty.GetDataSourcePropName: string;
begin
  Result := 'LookupSource';
end;

procedure TRxFieldProperty.GetValueList(List: TStrings);
var
  Instance: TComponent;
  PropInfo: PPropInfo;
  DataSource: TDataSource;
begin
  Instance := TComponent(GetComponent(0));
  PropInfo := TypInfo.GetPropInfo(Instance.ClassInfo, GetDataSourcePropName);
  if (PropInfo <> nil) and (PropInfo^.PropType^.Kind = tkClass) then
  begin
    DataSource := TObject(GetOrdProp(Instance, PropInfo)) as TDataSource;
    if (DataSource <> nil) and (DataSource.DataSet <> nil) then
      DataSource.DataSet.GetFieldNames(List);
  end;
end;

{ TTableNameProperty }
{ For TFieldList, TIndexList components }

type
  TTableNameProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

procedure TTableNameProperty.GetValueList(List: TStrings);
begin
{$IFDEF WIN32}
  (GetComponent(0) as TCustomTableItems).DBSession.GetTableNames((GetComponent(0)
    as TCustomTableItems).DatabaseName, '', True, False, List);
{$ELSE}
  Session.GetTableNames((GetComponent(0) as TCustomTableItems).DatabaseName,
    '', True, False, List);
{$ENDIF WIN32}
end;

{$IFNDEF RX_D4}

{$IFNDEF VER90}
 {$IFNDEF VER93}
function EditQueryParams(DataSet: TDataSet; List: TParams): Boolean;
begin
  Result := QBndDlg.EditQueryParams(DataSet, List, hcDQuery);
end;
 {$ENDIF}
{$ENDIF}

{ TParamsProperty }
{ For TQBEQuery component }

type
  TParamsProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetValue: string; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

procedure TParamsProperty.Edit;
var
  List: TParams;
  Query: TQBEQuery;
begin
  Query := GetComponent(0) as TQBEQuery;
  List := TParams.Create;
  try
    List.Assign(Query.Params);
    if EditQueryParams(Query, List) {$IFDEF WIN32} and not
      List.IsEqual(Query.Params) {$ENDIF} then
    begin
{$IFDEF WIN32}
      Modified;
{$ELSE}
      if Designer <> nil then Designer.Modified;
{$ENDIF}
      Query.Close;
      Query.Params := List;
    end;
  finally
    List.Free;
  end;
end;

function TParamsProperty.GetValue: string;
begin
  Result := Format('(%s)', [TParams.ClassName]);
end;

function TParamsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog];
end;

{$ENDIF RX_D4}

{ TUserTableNameProperty }

type
  TUserTableNameProperty = class(TDBStringProperty)
    procedure GetValueList(List: TStrings); override;
  end;

procedure TUserTableNameProperty.GetValueList(List: TStrings);
var
  Security: TDBSecurity;
begin
  Security := GetComponent(0) as TDBSecurity;
  if Security.Database <> nil then begin
{$IFDEF WIN32}
    Security.Database.Session.GetTableNames(Security.Database.DatabaseName,
      '*.*', True, False, List);
{$ELSE}
    Session.GetTableNames(Security.Database.DatabaseName, '*.*',
      True, False, List);
{$ENDIF}
  end;
end;

{ TLoginNameFieldProperty }

type
  TLoginNameFieldProperty = class(TDBStringProperty)
    procedure GetValueList(List: TStrings); override;
  end;

procedure TLoginNameFieldProperty.GetValueList(List: TStrings);
var
  Security: TDBSecurity;
  Table: TTable;
begin
  Security := GetComponent(0) as TDBSecurity;
  if (Security.Database <> nil) and (Security.UsersTableName <> '') then begin
    Table := TTable.Create(Security);
    try
      Table.DatabaseName := Security.Database.DatabaseName;
      Table.TableName := Security.UsersTableName;
      Table.GetFieldNames(List);
    finally
      Table.Free;
    end;
  end;
end;

{$IFNDEF RX_D4}

{ TMacroParamsProperty }
{ for TRxQuery component }

type
  TMacroParamsProperty = class(TParamsProperty)
  public
    procedure Edit; override;
    function GetValue: string; override;
  end;

function TMacroParamsProperty.GetValue: string;
begin
  Result := '(Macro)';
end;

procedure TMacroParamsProperty.Edit;
var
  List: TParams;
  Query: TRxQuery;
begin
  Query := GetComponent(0) as TRxQuery;
  List := TParams.Create;
  try
    List.Assign(Query.Macros);
    if EditQueryParams(Query, List) {$IFDEF WIN32} and not
      List.IsEqual(Query.Macros) {$ENDIF} then
    begin
{$IFDEF WIN32}
      Modified;
{$ELSE}
      if Designer <> nil then Designer.Modified;
{$ENDIF}
      Query.Close;
      Query.Macros := List;
    end;
  finally
    List.Free;
  end;
end;

{ TScriptParamsProperty }
{ for TSQLScript component }

type
  TScriptParamsProperty = class(TParamsProperty)
  public
    procedure Edit; override;
  end;

procedure TScriptParamsProperty.Edit;
var
  List: TParams;
  Query: TQuery;
  Script: TSQLScript;
begin
  Script := GetComponent(0) as TSQLScript;
  Query := TQuery.Create(Script);
  try
    Query.DatabaseName := Script.DatabaseName;
    Query.SQL := Script.SQL;
    Query.Params := Script.Params;
    List := TParams.Create;
    try
      List.Assign(Script.Params);
      if EditQueryParams(Query, List) {$IFDEF WIN32} and not
        List.IsEqual(Query.Params) {$ENDIF} then
      begin
{$IFDEF WIN32}
        Modified;
{$ELSE}
        if Designer <> nil then Designer.Modified;
{$ENDIF}
        Script.Params := List;
      end;
    finally
      List.Free;
    end;
  finally
    Query.Free;
  end;
end;

{$ENDIF RX_D4}

{ Designer registration }

procedure Register;
begin
  { Data aware components and controls }
  RegisterComponents(LoadStr(srRXDBAware), [TRxQuery, TSQLScript,
    TMemoryTable, TQBEQuery, TRxDBFilter, TRxDBGrid, TRxDBLookupList,
    TRxDBLookupCombo, TRxLookupEdit, TDBDateEdit, TRxDBCalcEdit,
    TRxDBComboEdit, TDBStatusLabel, TRxDBComboBox,
    {$IFDEF WIN32} TRxDBRichEdit, {$ENDIF} TDBIndexCombo, TDBProgress,
    TDBSecurity]);
  { Database lists }
  RegisterComponents(LoadStr(srRXDBAware), [TBDEItems, TDatabaseItems,
    TTableItems]);
{$IFNDEF CBUILDER}
 {$IFDEF USE_OLD_DBLISTS}
  RegisterComponents(LoadStr(srRXDBAware), [TDatabaseList, TLangDrivList,
    TTableList, TStoredProcList, TFieldList, TIndexList]);
 {$ENDIF USE_OLD_DBLISTS}
{$ENDIF CBUILDER}

{$IFDEF RX_D3}
  RegisterNonActiveX([TRxQuery, TSQLScript, TMemoryTable, TQBEQuery,
    TRxDBFilter, TRxDBGrid, TDBDateEdit, TDBStatusLabel, TRxDBComboBox,
    TRxDBLookupList, TRxDBLookupCombo, TRxLookupEdit, TRxDBComboEdit,
    TRxDBCalcEdit, TDBIndexCombo, TRxDBRichEdit, TDBProgress, TDBSecurity,
    TBDEItems, TDatabaseItems, TTableItems, TCustomDBComboBox,
    TRxLookupControl], axrComponentOnly);
{$ENDIF RX_D3}

  { Property and component editors for data aware controls }
  RegisterPropertyEditor(TypeInfo(string), TRxLookupControl, 'LookupField',
    TRxFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TRxLookupEdit, 'LookupField',
    TRxFieldProperty);
{$IFDEF RX_D3}
  RegisterPropertyEditor(TypeInfo(Integer), TRxDBGrid, 'RowsHeight', nil);
{$ENDIF}
  RegisterPropertyEditor(TypeInfo(TFileName), TCustomTableItems, 'TableName',
    TTableNameProperty);
  RegisterPropertyEditor(TypeInfo(TFileName), TDBSecurity,
    'UsersTableName', TUserTableNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TDBSecurity,
    'LoginNameField', TLoginNameFieldProperty);

{$IFNDEF RX_D4}
  RegisterPropertyEditor(TypeInfo(TParams), TQBEQuery, 'Params',
    TParamsProperty);
  RegisterPropertyEditor(TypeInfo(TParams), TRxQuery, 'Macros',
    TMacroParamsProperty);
  RegisterPropertyEditor(TypeInfo(TParams), TSQLScript, 'Params',
    TScriptParamsProperty);
{$ENDIF}

  RegisterPropertyEditor(TypeInfo(string), TSQLScript, 'DatabaseName',
    TDatabaseNameProperty);
{$IFDEF WIN32}
  RegisterPropertyEditor(TypeInfo(string), TCustomBDEItems, 'SessionName',
    TSessionNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TSQLScript, 'SessionName',
    TSessionNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TDBProgress, 'SessionName',
    TSessionNameProperty);
{$ELSE}
  DbErrorIntercept;
{$ENDIF WIN32}
end;

end.