{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{-------------------------------------------------------------------------------
Version  : 0.80.00
Date     : 27.4.1998
Dialog   : Select connection
History  : 
-------------------------------------------------------------------------------}

unit SelectC;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  xForms, Dialogs, StdCtrls, RXSplit, ExtCtrls, INIFiles;

type
  TfSelectConnection = class(TxForm)
    pnList          : TPanel;
    ConnectionsList : TListBox;
    pnButtons       : TPanel;
    bvSep           : TBevel;
    btnConnect      : TButton;
    btnParameters   : TButton;
    btnNew          : TButton;
    btnDelete       : TButton;
    btnCancel       : TButton;
    btnUp           : TButton;
    btnDown         : TButton;
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure btnParametersClick(Sender: TObject);
    procedure btnNewClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure ConnectionsListDblClick(Sender: TObject);
  private
    { Private declarations }
    Procedure Check;
    Function RSelectedServer:String;
  public
    { Public declarations }
    constructor Create(aOwner:TComponent); override;
    destructor Destroy; override;
    Function ReadMSG:Boolean; override;
    property SelectedServer : String read RSelectedServer;
  end;

Var
  fSelectConnection : TfSelectConnection;
implementation
Uses
  xTerm, Forms, STConfig, ConnPar, kUnits, SafeMem, C3216;
{$R *.DFM}
Const
  ctQRealyDelete : String = 'Skuten chcete vymazat spoj "%s" z tabulky spoj?';
  ctConnExists   : String = 'Spoj s takovmto popisem ji existuje, zvolte jin.';
  ctComentOrHost : String = 'Adresa vzdlenho systmu a popis mus bt vyplnny.';


procedure TfSelectConnection.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  If (Shift=[]) and (Key=VK_ESCAPE) Then Close;
end;

procedure TfSelectConnection.btnParametersClick(Sender: TObject);
Var
  PData : PdConnectionParameters;
  I     : Integer;
Begin
  If not AllocateDialog(_fConnectionParameters) Then Exit;

  PData := STConfig.ConnectionFind(SelectedServer);
  I     := ConnectionsList.ItemIndex;
  If PData<>nil Then
   Begin
     fConnectionParameters.Data:=PData^;
     If fConnectionParameters.ShowModal=mrOk Then
      Begin
        PData^ := fConnectionParameters.Data;
        If PData^.Connection.Caption='' Then PData^.Connection.Caption:=PData^.Connection.Host;
      End;
   End;
  Check;
  ConnectionsList.ItemIndex:=I;
End;{-- btnParametersClick ----------------------------------------------------}
procedure TfSelectConnection.btnNewClick(Sender: TObject);
Var
  PData : PdConnectionParameters;
Label
  Znovu;
begin
  If not AllocateDialog(_fConnectionParameters) Then Exit;

  SafeGetMem(PData,SizeOf(TdConnectionParameters));
  If ConnectionsList.ItemIndex>=0 Then Begin
   PData^:=PdConnectionParameters(CFG^.Connections.Items[ConnectionsList.ItemIndex])^;
   PData^.Environment.List                     := TStringList.Create;
   PData^.Environment.List.Duplicates          := dupIgnore;
   PData^.Environment.List.Sorted              := True;
   { Tento pointer nelze zkopirovat!!!, dusledkem je GPF na konci programu po
     pridani noveho spojeni}
   PdConnectionParameters(CFG^.Connections.Items[ConnectionsList.ItemIndex])^.Environment.List.Assign(PData^.Environment.List);
   PData^.Connection._Enabled                  := True;
   PData^.CharSet._Enabled                     := True;
   PData^.Security._Enabled                    := True;
   PData^.Security.Logging._Enabled            := True;
   PData^.Security.OTP._Enabled                := True;
   PData^.Security.SSL._Enabled                := False;
   PData^.Console._Enabled                     := True;
   PData^.Console.Font._Enabled                := True;
   PData^.Console.Window._Enabled              := True;
   PData^.Console.Colors._Enabled              := True;
   PData^.UserAcounts._Enabled                 := False;
   PData^.Connection.Caption                   := '';
  End Else Begin
   PData^.Environment.List                     := Nil;
   ConnectionDefault(PData);
  End;

  fConnectionParameters.Data:=PData^;
Znovu:
  If fConnectionParameters.ShowModal=mrOk Then
   Begin
     PData^:=fConnectionParameters.Data;
     If PData^.Connection.Caption='' Then PData^.Connection.Caption:=PData^.Connection.Host;
     If (PData^.Connection.Caption='')or(PData^.Connection.Host='') Then
      Begin
        MessageBox(Handle,@ctComentOrHost[1],
                          @ctError[1],MB_ICONSTOP or MB_OK);
        Goto Znovu;
      End;
     If STConfig.ConnectionExists(PData^.Connection.Caption) Then
      Begin
        MessageBox(Handle,@ctConnExists[1],
                          @ctError[1],MB_ICONSTOP or MB_OK);
        Goto Znovu;
      End;
     STConfig.ConnectionAdd(PData);
   End
  Else
    SafeFreeMem(PData,SizeOf(PdConnectionParameters));
  Check;
end;{-- btnParametersClick ----------------------------------------------------}
procedure TfSelectConnection.btnDeleteClick(Sender: TObject);
Var
  S        : ShortString;
  Selected : Integer;
begin
  S:=Format(ctQRealyDelete+#0,[SelectedServer]);
  If MessageBox(Handle,@S[1],@ctQuestion[1],MB_ICONQUESTION or MB_YESNO)=IDYES Then
   Begin
     Selected:=ConnectionsList.ItemIndex;
     STConfig.ConnectionDelete(SelectedServer);
     Check;
     If Selected>0 Then ConnectionsList.ItemIndex:=Selected-1
     Else ConnectionsList.ItemIndex:=0;
   End;
end;{-- btnDeleteClick --------------------------------------------------------}
procedure TfSelectConnection.btnUpClick(Sender: TObject);
Var
  Selected : Integer;
  P1       : Pointer;
begin
  If ConnectionsList.ItemIndex>0 Then Begin
    Selected := ConnectionsList.ItemIndex;
    P1 := CFG^.Connections.Items[Selected];
    CFG^.Connections.Items[Selected] := CFG^.Connections.Items[Selected-1];
    CFG^.Connections.Items[Selected-1] := P1;
    Check;
    ConnectionsList.ItemIndex := Selected-1;
  End;
end;{-- btnUpClick ------------------------------------------------------------}
procedure TfSelectConnection.btnDownClick(Sender: TObject);
Var
  Selected : Integer;
  P1       : Pointer;
begin
  If ConnectionsList.ItemIndex<CFG^.Connections.Count-1 Then Begin
    Selected := ConnectionsList.ItemIndex;
    P1 := CFG^.Connections.Items[Selected];
    CFG^.Connections.Items[Selected] := CFG^.Connections.Items[Selected+1];
    CFG^.Connections.Items[Selected+1] := P1;
    Check;
    ConnectionsList.ItemIndex := Selected+1;
  End;
end;{-- btnUpClick ------------------------------------------------------------}

Procedure TfSelectConnection.Check;
Begin
  STConfig.ConnectionMakeList(ConnectionsList.Items);
  btnConnect.Enabled    := ConnectionsList.Items.Count>0;
  btnParameters.Enabled := ConnectionsList.Items.Count>0;
  btnDelete.Enabled     := ConnectionsList.Items.Count>0;
  btnUp.Enabled         := ConnectionsList.Items.Count>0;
  btnDown.Enabled       := ConnectionsList.Items.Count>0;
  If ConnectionsList.ItemIndex<0 Then ConnectionsList.ItemIndex:=0;
  btnCancel.Enabled     := not SuperUser;
End;

Function TfSelectConnection.RSelectedServer;
Begin
  If ConnectionsList.ItemIndex>=0 Then
   Result:=ConnectionsList.Items[ConnectionsList.ItemIndex]
  Else
   Result:='';
End;

Function TfSelectConnection.ReadMSG:Boolean;
Begin
  Result := inherited ReadMSG;
  If Result Then Begin
    btnCancel.Caption     := ctbtnCancel;
    If SuperUser Then btnConnect.Caption:=ctbtnOk;

    ctQRealyDelete        := ReadMSGString('QRealyDelete');
    ctConnExists          := ReadMSGString('ConnExists');
    ctComentOrHost        := ReadMSGString('ComentOrHost');
  End;
End;

procedure TfSelectConnection.ConnectionsListDblClick(Sender: TObject);
begin
  If SuperUser Then btnParametersClick(self)
  Else ModalResult := mrOk;
end;

constructor TfSelectConnection.Create(aOwner:TComponent);
Begin
  Inherited Create(aOwner);
  {$IFDEF Win32}
  ConnectionsList.BorderStyle:=bsSingle;
  {$ENDIF}

  Name         := 'fSelectConnection';

  SaveSize     := True;
  SavePosition := True;

  ReadINI;

  Check;
  ConnectionsList.ItemIndex:=0;
End;

destructor TfSelectConnection.Destroy;
Begin
  WriteINI;

  Inherited Destroy;
End;


initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuSelectC, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuSelectC, 'finalization', '');{$ENDIF}{$ENDIF}
end.
