{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{-------------------------------------------------------------------------------
Version  : 0.81.00
Date     : 30.4.1998
Dialog   : One line dialog, should be used for input of one line of text
Comments : Has method whitch safetly deletes password
History  : 30.4.1998 QC
TODO     :
-------------------------------------------------------------------------------}
unit OneLine;

interface

uses
  Forms,    Classes, Controls, StdCtrls,
  INIFiles, xForms;

type
  TfOneLineDlg = class(TxForm)
    FUserText    : TLabel;
    FOneLine     : TEdit;
    btnOk        : TButton;
    btnCancel    : TButton;
  private
    { Private declarations }
    Function  ROneLine:string;
    Procedure WOneLine(S:string);
    Procedure WUserText(S:String);
    Procedure WPassMode(B:Boolean);
  public
    { Public declarations }
    Procedure DisartPass;
    Function ReadMSG:Boolean; override;
    property UserText : String                  write WUserText;
    property OneLine  : String  read  ROneLine  write WOneLine;
    property PassMode : Boolean                 write WPassMode;
  end;

Var
  fOneLineDlg : TfOneLineDlg;
implementation
Uses
  STConfig, kUnits;
{$R *.DFM}

Function TfOneLineDlg.ROneLine:String;
Begin
  Result:=FOneLine.Text;
End;

Procedure TfOneLineDlg.WOneLine(S:String);
Begin
  FOneLine.Text:=S;
End;

Procedure TfOneLineDlg.WUserText(S:String);
Begin
  FUserText.Caption := S;
End;

Procedure TfOneLineDlg.WPassMode(B:Boolean);
Begin
  If B Then
   FOneLine.PasswordChar := '*'
  Else
   FOneLine.PasswordChar := #0;
End;

Function TfOneLineDlg.ReadMSG:Boolean;
Begin
  Result := inherited ReadMSG;
  If Result Then Begin
    btnOk.Caption     := ctbtnOk;
    btnCancel.Caption := ctbtnCancel;
  End;
End;

Procedure TfOneLineDlg.DisartPass;
Var
  I : Word;
  S : String;
Begin
  S:='';
  For I:=0 To Length(FOneLine.Text) Do S:=S+#0;
  FOneLine.Text:=S;
  FOneLine.Text:='';
End;

initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuOneLine, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuOneLine, 'finalization', '');{$ENDIF}{$ENDIF}
End.

