{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit pgpPKey;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, xForms;

type
  TfPGPPublicKey = class(TxForm)
    PGPKey: TMemo;
    btnOk: TButton;
    Button1: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Constructor Create(aOwner:TComponent); override;
    Destructor Destroy; override;
  end;

var
  fPGPPublicKey: TfPGPPublicKey;

implementation
{$R *.DFM}
Uses
  STConfig, kUnits;

Const
(*  pg : Array[0..15-1] of String[64] = (
   ('U}rh!EjCLiZK 5''''Rhyz''3.''&,4mw~7[G'),
   ('syf1+91GF?8H=NH<@M!EFF=@C:7I>+_xjuo"hlntfwzw1nf'),
   (''),
   ('0/555LVJXN#\Sg)ZfQ\Z[8WU[-H\ZJK5?88D'),
   ('br{u}oM 83?@Ivq'),
   (''),
   ('mc[aF~`{HoPSYI[DZ5pusgid?{<Szr[AqjXrjZ7zSumKOzx<Lr|^HvBh'),
   ('wG6RZ~x^:?U@f\Tc\pct`dx^At\rCJjhLThnT{|DmWOg>6H]QJQ0z]h'),
   ('`]D:S`vX?Ovp@lXQ2hUOM[Ve_x3W6co@ecRFLN\]ecWgfiztG`YOmcDRdc'),
   ('Rj`qX6hlY|qescjjf;wx[>hiC{YTzllbvJtS`OPX_tvKttPukKQznXmYWJSg\L'),
   ('M^it]btUpAe;|`|RT?H`zcdz_m/=76uy^E]/:d:x|GyJOreItxZeya'),
   ('\JR8HY8[__GBv2tgZubX5@duPSAxIilMLyPM?UAL6WeQ~wTRK|uq`MR'),
   ('weknrUV~B8\bap{rEkS|SnSsqLH;Ww\_st{^PnA'),
   ('EHS[^'),
   ('D834;\bX5P[R8_]FSQM$QR[.RbRFN0:519')); *)
   pg : array[0..37-1] of string[64] = (
   ('y"7B1B>ECVG7N7C4Z74;MN7D3-G9(Ya~3d{vlf3.Y}dym6'),
   ('276%(Xl!f~yoo}z|l|.O)I8A?&QM==3?Y@E HRST!GY:9'),
   ('5$/ 71#.771($37#,$)''11)4I?8&H?AC+HOH:!IFA=55MGE'),
   ('yb--A>GFsBDB?0ZO3:"AQ<O7;J03<'),
   (''),
   ('E<:82JS[\d.SOQ*PYLPZ[+USY!TaVVQ;81-E'),
   ('k}ys~F&P}w[M(xF8@=>+(NcYCXyz<'),
   ('Mypknv=(Ls nqq|%ok!~ut@87w{7ruxys6o~m'),
   (''),
   ('shKnEMneRYWXJOtsNfGQ`sjIDhNpj{Kd{j]TG[M>V}|{nYWHBr1XU=]'),
   ('vtZ{fnH[}C\yVIY@OO;7swOYbyFtGQ`pD]fnPczErI|e9uxXRWj{Lmo'),
   ('K|mZIji^}9bT8XsHN>}>KTtPQJZX~I;y[`INh`bRlo{J\gUJ|G^~'),
   ('w}x_kp5~5MjE>ttgVZu}\A7K[w5D|wVr_bNVMUPHUzYHcUEiIYoiiy;~7qG'),
   ('mzuePDy1uFDfT?sRYudkS_ptD3[lScgkfxTLYdN=qVwoFzxlgyQWD}YL0{'),
   ('jtn7pI7xy]v6f[ti;7_GfIVy}ixue]S~Ug}cr}bmSY{R]Wula;ty{q[iib'),
   ('v;EgU7<pw`DSFUXJ}m{vM~YtXXjPkInOO~LIjMYqwDg2Wp@jke7`QhRy'),
   ('YM|3UI]_K>qCmFODwe`On9gyZR|dtRsZQJi[>Ciax;s6=UJYO[{JhjU9U'),
   ('xGZaJfZLYEyTWBaY<R6w}382qTftum3coP]Wjn;k[oBQ]h|IvSL_zhY'),
   ('`oq\SZg[elzT}QcSYYEXZFT]\ROIUwgUeOSoYK]c\VRxnXKYQb{SEbLZSVdT8'),
   ('RhMXU8~V]VepgGXz7m{g@{l_nyQuVzU@kdZyd4WOw1bUF~i>CpIj}r~HXu'),
   ('xPH]`{QQVhVRYmUV`HSo}I`UTI<kkF~HHzVbMXRRV[W[4fN~|]IQYjeFkwuy'),
   ('WHNPwTged^BaI`hSd?FSyDz>PZ6UCsyBLr=ZPLJjuWJBTACj1RiIlNrC'),
   ('nNnb>p5zwBOFnJak\5S[x^MZUZYFx}_TDCUjBPdF^x[z{Lv\^|M'),
   ('jzZLuyTzNyQEfFdr=I:fkzrP{geG;]VnSwyt1|V6[Oz:Kj{U28F8yfwvN~L0'),
   ('v8DRhNHZ]@rrdOWG{Fg{i4cZn:qYaWlI{RpMDYcU__bGMJx_}X?2EfwjeuK'),
   (']{?zX]xQ`O?~knMIhoQ9JJHdRV7r~_9tJZ>;@Q0cQEr?d[{{T`|UZy}~'),
   ('WCZhbS~bwvFpbH[?Mm>lKsKtL`;Vc~[{SyEOw}jXQ:YxI^VsW|mQro'),
   ('tUTf8xJFkZB@B9QqBZkGDvl}Qi8}IT?D\TXe_UM\EZvuG4BcU7UyM_vJ['),
   ('nylcBm~]_kmoeriOew0m7\RNUcUlUTrYPcnq;{n}B_wY9~T9zWsIMv}_Z'),
   ('9rWrUa?Sl\z?X9SMYGHy\sd0ulB=Z`bWbhqqsxXQdo88ozzw|FI^xU'),
   ('ncD^k<Yul@ZbL_W>oMScR;2MKHqlZ7lj5yTOuoqm:jUqR``hYysJa'),
   ('a6[KjETnK|PEYN\CC`6IyzHdu}HOa\@~2VLi}HYioT{mcwXqypASpj^Fd'),
   ('Vs.igVXzRuxw?zOOYY9?cpSM5az>_Y`>t3_Y~VhQ]OGLu[NYUE{WiBLQXDYoU<'),
   ('{VsRZ[8LKXG|XcrW2VIRHzi6cBVPCHR6UF}\X|HHgWj=mltilaGvAbsNn_'),
   ('\='),
   ('CWIG'),
   ('6D;88KVN+eHb3bjWSLG#\[d+EWcVQ@?/?3')
   );

Constructor TfPGPPublicKey.Create(aOwner:TComponent);
Begin
  Inherited Create(aOwner);
  Name              := 'fPGPPublicKey';
  SavePosition      := True;
  ReadINI;

  Button1.Visible   := False;
  PGPKey.ReadOnly   := not Button1.Visible;
End;

Destructor TfPGPPublicKey.Destroy;
Begin
  WriteINI;

  Inherited Destroy;
End;

procedure TfPGPPublicKey.Button1Click(Sender: TObject);
Var
  S : PChar;
  I : Integer;
begin
  S := StrAlloc(PGPKey.GetTextLen+1);
  PGPKey.GetTextBuf(S, PGPKey.GetTextLen+1);
  RandSeed:=PGPKey.GetTextLen;
  For I:=0 To PGPKey.GetTextLen-1 Do
    If not(S[I] in [#10, #13]) Then S[I]:=chr(ord(S[I])+random(25));
  PGPKey.SetTextBuf(S);
end;

procedure TfPGPPublicKey.FormShow(Sender: TObject);
Var
  S      : PChar;
  I,J,K,L: Integer;
begin
  J:=0;
  For I:=0 To 37-1 Do Begin {Delka vysledneho otevreneho textu}
    Inc(J,Length(pg[I])+2);
  End;
  S := StrAlloc(J+1);

  RandSeed:=J;

  L:=0;
  For I:=0 To 37-1 Do Begin
    For K:=0 To Length(pg[I])-1 Do Begin S[L]:=chr(ord(pg[I][K+1])-(random(25))); Inc(L); End;
    If I<36 Then Begin S[L]:=#13; Inc(L); S[L]:=#10; Inc(L); End;
  End;
  S[L]:=#0;

  PGPKey.SetTextBuf(S);
end;

procedure TfPGPPublicKey.FormHide(Sender: TObject);
begin
  PGPKey.Clear;
end;


procedure TfPGPPublicKey.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  If Key=VK_ESCAPE Then Close;
end;

initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuPGPPKey, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuPGPPKey, 'finalization', '');{$ENDIF}{$ENDIF}
end.
